#ifndef __PCICC32_H__
#define __PCICC32_H__
//-------------------------------------------------------------------------
// WINNT driver for PCICC32 interface from ARW Elektronik, Germany --------
// IO definitions and common data structures between application and driver
//
// (c) 2000,2001 ARW Elektronik
//
// this source code is published under GPL (Open Source). You can use, redistrubute and 
// modify it unless this header   is not modified or deleted. No warranty is given that 
// this software will work like expected.
// This product is not authorized for use as critical component in life support systems
// wihout the express written approval of ARW Elektronik Germany.
//
// Please announce changes and hints to ARW Elektronik
//
// what                                            who          when
// started                                         AR           16.04.2000
// added irq functionality                         AR           24.02.2001
// added until 'not Q' read/write mode             AR           03.03.2001
// added AUTOREAD                                  AR           17.03.2001
//

//-------------------------------------------------------------------------
// INCLUDES
//
// #include <devioctl.h> must be declared before inclusion when used for driver
// #include <winioctl.h> must be declared before inclusion when used for applications

//-------------------------------------------------------------------------
// DEFINES
//

//----------------------------------------------------------------------------------------
// macros for simple CAMAC NAF address calculation
//
#define NAF(n, a, f) ((ULONG)((n << 10) + (a << 6) + ((f & 0xf) << 2)))

// to get a compatible view to WIN95 driver 
#define USER_CONTROL_CODE(x) (x)  

// VPCIC32D_ATTACH_CC32 and VPCIC32D_DETACH_CC32 are incompatible to WINNT - please use read and write commands
				
// get the interrupt and timeout status from a CC32 interface (0x00220008)
#define PCICC32_GET_STATUS       CTL_CODE(\
								 FILE_DEVICE_UNKNOWN,\
								 USER_CONTROL_CODE(2),\
								 METHOD_BUFFERED,\
								 FILE_ANY_ACCESS)

// clear the timeout status of a CC32 interface (0x0022000C)
#define PCICC32_CLEAR_STATUS     CTL_CODE(\
								 FILE_DEVICE_UNKNOWN,\
								 USER_CONTROL_CODE(3),\
								 METHOD_BUFFERED,\
								 FILE_ANY_ACCESS)

// set the access parameter for this file (0x00220010)
#define PCICC32_SET_ACCESS_PARA	 CTL_CODE(\
								 FILE_DEVICE_UNKNOWN,\
								 USER_CONTROL_CODE(4),\
								 METHOD_BUFFERED,\
								 FILE_ANY_ACCESS)

// allow or inhibit CC32 interrupt requests (0x00220014)
#define PCICC32_CONTROL_INTERRUPTS	 CTL_CODE(\
								 FILE_DEVICE_UNKNOWN,\
								 USER_CONTROL_CODE(5),\
								 METHOD_BUFFERED,\
								 FILE_ANY_ACCESS)

// requests thru blocking io the status of a pending or a rising interrupt (0x0022001C)
#define PCICC32_INSTALL_IRQ_BLOCK	 CTL_CODE(\
								 FILE_DEVICE_UNKNOWN,\
								 USER_CONTROL_CODE(7),\
								 METHOD_BUFFERED,\
								 FILE_ANY_ACCESS)

// requests to access the PLX LCR for test and debug (0x00220020)
#define PCICC32_ACCESS_LCR   	 CTL_CODE(\
								 FILE_DEVICE_UNKNOWN,\
								 USER_CONTROL_CODE(8),\
								 METHOD_BUFFERED,\
								 FILE_ANY_ACCESS)

// set to check for control-code overflow
#define PCICC32_LAST_CTL_CODE PCICC32_ACCESS_LCR

// mask bits for interrupt status
#define LAM_IRQ             0x00FFFFFF  // there was a LAM responible for the timeout
#define CONNECTION_TIMEOUT	0x08000000  // irq raised through a connection timout
#define LAM_BUS_OR          0x10000000  // a LAM-BUS-OR is pending
#define LAM_NOT_OR          0x20000000  // a LAM-NOT-OR is pending
#define LAM_AND_OR          0x40000000  // a LAM-AND-OR is pending
#define LAM_FF              0x80000000  // the LAM-Flip-Flop was set

// switches for PCICC32_ACCESS_COMMAND.wAccessType
#define WORD_ACCESS (UCHAR)2   //            word
#define LONG_ACCESS (UCHAR)4   //            long

// define bits for PCICC32_ACCESS_COMMAND.wBlockTransfer
#define UNTIL_NOT_Q         0x0001      // read/write unttil 'not Q' switch
#define AUTOREAD            0x0002      // PCIADA data pipelining access tuner switch

// data lane size constants for PCICC32_ACCESS_LCR
#define BYTE_ACCESS (UCHAR)1   // write byte wise (illegal)
#define WORD_ACCESS (UCHAR)2   //       word
#define LONG_ACCESS (UCHAR)4   //       long

// PCICC32_ACCESS_LCR access constants
#define LCR_READ       0       // read only access
#define LCR_WRITE      1       // write and read back access
#define LCR_OR         2       // read, bitwise 'or' content and read back access
#define LCR_AND        3       // read, bitwise 'and' content and read back access
#define LCR_WRITE_ONLY 4       // do not read back after write

// this structure is output from VPCIC32_GET_STATUS call
typedef struct
{
	ULONG  dwInterface;         // CC32 module number (for compatibility to win95/98 only - not used)
	USHORT bTimeout;            // denotes a pending PCIADA timeout
	USHORT bInterrupt;          // denotes a pending LAM interrupt
} PCICC32_STATUS;    

// this structure sets the access parameter for following reads or writes to this path
typedef struct 
{
	ULONG  dwInterface;        // CC32 module number (for compatibility to win95/98 only - not used)   
	USHORT wAccessType;		   // set the current access type (WORD_ACCESS, LONG_ACCESS)
	USHORT wBlockTransfer;	   // set AUTOREAD or UNTIL_NOT_Q
} PCICC32_ACCESS_COMMAND; 

// this structure is used to control the interrupts
typedef struct
{
	ULONG  dwInterface;        // CC32 module number (for compatibility to win95/98 only - not used)
	USHORT wEnable;            // a 1 allows, a 0 inhibits interrupt requests
} PCICC32_IRQ_CONTROL;

// this structure returns from a blocking interrupt status call
typedef struct
{
	ULONG  dwInterface;        // CC32 module number (for compatibility to win95/98 only - not used)
	ULONG  dwInterruptFlags;   // the return status at the return of the blocking call
} PCICC32_IRQ_RESPONSE;  

// structure to access the local configuration space of PLX chip (test / debug only) with PCICC32_ACCESS_LCR
typedef struct
{
  ULONG	 dwInterface;         // here dummy 'cause of compatibility to WIN95
  ULONG  dwContent;           // content to write, and, or
  USHORT wRegisterAddress;    // address offset of LCR register
  UCHAR  bAccessMode;         // LCR_READ, write, or, and
  UCHAR  bBytesLane;          // the data access width
} PCICC32_LCR_ACCESS;

#endif // __PCICC32_H__
