#ifndef __PCICC33_I_H__
#define __PCICC32_I_H__

//-------------------------------------------------------------------------
// WINNT driver for PCICC32 interface from ARW Elektronik, Germany ---------
// the header file to pcicc32_i.c - all around interrupt handling
//
// (c) 1999 ARW Elektronik
//
// this source code is published under GPL (Open Source). You can use, redistrubute and 
// modify it unless this header   is not modified or deleted. No warranty is given that 
// this software will work like expected.
// This product is not authorized for use as critical component in life support systems
// wihout the express written approval of ARW Elektronik Germany.
//
// Please announce changes and hints to ARW Elektronik
//
// what                                            who          when
// started                                         AR           15.06.1999
// added globalInterruptEnabledStatus()            AR           24.02.2001
//

//-------------------------------------------------------------------------
// INCLUDES
//
#include <ntddk.h>
#include <pcicc32_drv.h>

//------------------------------------------------------------------------
// DEFINES
//

//------------------------------------------------------------------------
// PROTOTYPES
//
void globalInterruptEnable(PCIADA *pciada);
void globalInterruptDisable(PCIADA *pciada);
unsigned short globalInterruptEnabledStatus(PCIADA *pciada);
NTSTATUS PCICC32TranslateInterrupt(PDEVICE_OBJECT device_Obj);
NTSTATUS PCICC32ConnectInterrupt(PDEVICE_OBJECT device_Obj);
NTSTATUS PCICC32DisConnectInterrupt(PDEVICE_OBJECT device_Obj);


/* release all this procedures after init of the driver */
#ifdef ALLOC_PRAGMA
#pragma alloc_text (init, PCICC32ConnectInterrupt)
#pragma	alloc_text (init, PCICC32TranslateInterrupt)
#endif

/* put all this procedures in the paged memory-pool, all called at passiv Level */
#ifdef ALLOC_PRAGMA
#pragma alloc_text (page, PCICC32DisConnectInterrupt)
#endif

#endif //__PCICC32_I_H__
