#ifndef _PCICC32_LOCAL_H__
#define _PCICC32_LOCAL_H__
//-----------------------------------------------------------------------
// Address definitions and constants for PCIADA of PCICC32 interface 
// designed by A.Rausch         
//                                                                       
// (c) 1999 ARW Elektronik
//
// this source code is published under GPL (Open Source). You can use, redistrubute and 
// modify it unless this header   is not modified or deleted. No warranty is given that 
// this software will work like expected.
// This product is not authorized for use as critical component in life support systems
// wihout the express written approval of ARW Elektronik Germany.
//
// Please announce changes and hints to ARW Elektronik
//
// what                                              who   when          
// first parts derived from PCIVME                   AR    10.03.2000 
// added initialisation for AUTOREAD                 AR    17.03.2001  
//

/*-----------------------------------------------------------------------*/
/* all addresses relative to PCI-Window                                  */

/*--------- some masks in CSR -------------------------------------------*/
#define MASK_MODNR   (WORD)0x00F0       /* the mask to get the module No */
#define MASK_FPGA    (WORD)0x0F00       /* the mask to get the FPGA rev. */
#define MASK_MODTYPE (WORD)0xF000       /* the mask to get type of module*/

/*---------- release und inhibit into 0x50 of PLX ------------------------*/
#define RELEASE_CC32 (WORD)0x4186       /* write this to release access ..*/
#define INHIBIT_CC32 (WORD)0x4086       /* write this to inhibit access ..*/
#define ENABLE_PCIADA_IRQS  (WORD)0x0049 /* enable PCIADA IRQs            */
#define DISABLE_PCIADA_IRQS (WORD)0x0009 /* disable PCIADA IRQs           */

#endif // _PCICC32_LOCAL_H__
