#ifndef __PCICC32_DRV_H__
#define __PCICC32_DRV_H__
//-------------------------------------------------------------------------
// WINNT driver for PCICC32 interface from ARW Elektronik, Germany ---------
// the main header file of the driver
//
// (c) 1999 ARW Elektronik
//
// this source code is published under GPL (Open Source). You can use, redistribute and 
// modify it unless this header   is not modified or deleted. No warranty is given that 
// this software will work like expected.
// This product is not authorized for use as critical component in life support systems
// wihout the express written approval of ARW Elektronik Germany.
//
// Please announce changes and hints to ARW Elektronik
//
// what                                            who          when
// started                                         AR           10.03.2000
// dwIrqStatus added, version 2                    AR           24.02.2001
// with AUTOREAD, version 2.01                     AR           17.03.2001
// with support for LCR_READ, version 2.02         AR           31.03.2001
// changed to VisualStudio 6.0                     AR           30.09.2001
// compiled with DDK 1/2001                        AR           20.11.2001
// removed alloc_text cause of WIN2000 problems    AR           25.11.2001
// version 2.7 released                            AR           25.11.2001
// version 2.8 still experimental                  AR           26.05.2002
// version 2.16 eliminates PLXBUG in WIN2000       AR           05.06.2002
// version 2.17 added KeSynchronizeExecution       AR           16.06.2002
// version 2.18 improved snchronisation            AR           18.06.2002
//

//-------------------------------------------------------------------------
#define DRIVER_VERSION ((2 << 16) | 18) // the only place for version info
#define DRIVER_VARIANT 0                // mark customisation here
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// precautions for debug compile
#define PCICC32_DEBUG

#ifndef PCICC32_DEBUG
#ifdef  KdPrint
#undef  KdPrint
#define KdPrint(x) /* x */
#endif
#endif
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// INCLUDES
//
#define PCI_MAX_BUSES     4   // buses to search for pciada

#define PCICC32_MAX_PCIADA 4  // maximum of PCIADA to search for  
#define PCICC32_MAX_CC32  16  // maximum number of CC32 modules connected

//-------------------------------------------------------------------------
// DEFINES
//
#define PCICC32_VENDOR_ID  0x10B5  
#define PCICC32_DEVICE_ID  0x2258
#define PCICC32_SUBSYS_ID  0x2258
#define PCICC32_SUBVEN_ID  0x9050

#define LCR_SPACE         256    // space in bytes of LCR
#define IFR_SPACE         32768  // space in bytes of IFR

//----------------------------------------------------------------------------------------
// macros for simple address calculation
//
#define _WORD_NAF(base, n, a, f)  ((USHORT *)((ULONG)base + (n << 10) + (a << 6) + ((f & 0xf) << 2)))
#define _DWORD_NAF(base, n, a, f) ((ULONG  *)((ULONG)base + (n << 10) + (a << 6) + ((f & 0xf) << 2)))

//-------------------------------------------------------------------------
// TYPEDEFS
//
typedef struct _FILE_OBJ
{
	USHORT uwAssociatedCC32;		   // which CC32 number it belongs
	USHORT wAccessType;                // WORD or LONGWORD
	USHORT wBlockTransfer;             // != 0 for block transfer
	void   (*fRead)(void *to,  void *from); // resulting read
	void   (*fWrite)(void *to, void *from); // resulting write
	PIRP              blockingIrp;     // if != 0 then a blocking IRP is waiting
} FILE_OBJ, *PFILE_OBJ;

typedef struct
{
	int               Bus;             // bus number of pciada
	PCI_SLOT_NUMBER   Slot;            // slot + function number encoded
	PCI_COMMON_CONFIG PCIDevice;       // content of pcr, only for direct HW related functions

    PHYSICAL_ADDRESS  pvPhysLcr;       // local config register, unmapped and mapped
	PHYSICAL_ADDRESS  pvPhysIfr;       // interface registers, unmapped and mapped
	PVOID             pvVirtLcr;       // virtual LCR space
	PVOID             pvVirtIfr;       // virtual IFR space

	PKINTERRUPT       InterruptObject; // points to the associated interrupt obj
	KIRQL			  Irql;			   // virtual Irq level, unmapped and mapped
	ULONG			  Vector;	       // mapped system vector, unmapped and mapped
	KAFFINITY		  Affinity;        // which processor uses this irq, unmapped and mapped

	PUSHORT           pwCntrl;         // LCR Cntrl Offset @ LCR + 0x50
	PUSHORT           pwIntCSR;        // LCR IntCSR Offset @ LCR + 0x4C

	ULONG			  dwLinkCount;     // how often this interface is requested
    BOOLEAN			  bConnected;	   // CC32 is connected and powered
	USHORT			  wModuleNumber;   // Number (Jumper) of CC32
	USHORT			  wFPGAVersion;    // Revision of (CC32) FPGA
	USHORT			  wModuleType;     // Type of (CC32) module

	KDPC              kDPCobj;         // custom DPC object for irq tunneling

	ULONG             dwIrqStatus;     // the last unrequested status of a interrupt
	PIRP              *pBlockingIrp;   // points to File or == NULL when no blocking in progress 

	FILE_OBJ          *pIrqControlFile; // this file controls the global enable / disable IRQ
} PCIADA; 

typedef struct _DEVICE_EXT 
{
	PDEVICE_OBJECT DeviceObject;       // points to myself and carries the pointer to DriverObject
	PIRP actualIrp;					   // points to .. 

	int    nPCIADAs;                   // how many PCIADAs are found

	PCIADA pciada[PCICC32_MAX_PCIADA]; // for each PCIADA a descriptor 

	PCIADA *cc32[PCICC32_MAX_CC32];    // points to PCIADA to which it belongs

	int    nInitState;                 // tracks the state of initialisation
} DEVICE_EXT;


// Prototypes to support following pragmas
NTSTATUS DriverEntry(PDRIVER_OBJECT driverObj, PUNICODE_STRING regPath);
NTSTATUS PCICC32Open(PDEVICE_OBJECT deviceObj, PIRP irp);
NTSTATUS PCICC32Close(PDEVICE_OBJECT deviceObj, PIRP irp);
VOID     PCICC32Unload(PDRIVER_OBJECT driverObj);
NTSTATUS SearchDevices(PDEVICE_OBJECT device_Obj);
NTSTATUS PLX9050BugFix(PDEVICE_OBJECT deviceObj);
NTSTATUS PCICC32ReserveResources(PDEVICE_OBJECT device_Obj);
NTSTATUS PCICC32ExtractResources(PCIADA *pciada, PCM_RESOURCE_LIST pList); 
NTSTATUS PCICC32FreeResources(PDEVICE_OBJECT device_Obj);
NTSTATUS PCICC32TranslateBusAddress(PDEVICE_OBJECT device_Obj);
NTSTATUS PCICC32MapIOspace(PDEVICE_OBJECT device_object);
VOID     PCICC32SoftInit(PDEVICE_OBJECT device_Obj);
NTSTATUS InitializeCustomDPCObjects(PDEVICE_OBJECT device_object);

/* release all this procedures after init of the driver */
#ifdef ALLOC_PRAGMA
#pragma alloc_text (init, DriverEntry)
#pragma alloc_text (init, SearchDevices)
#pragma alloc_text (init, PLX9050BugFix)
#pragma alloc_text (init, PCICC32ReserveResources)
#pragma alloc_text (init, PCICC32ExtractResources)
#pragma alloc_text (init, PCICC32TranslateBusAddress)
#pragma alloc_text (init, PCICC32MapIOspace)
#pragma alloc_text (init, PCICC32SoftInit) 
#pragma alloc_text (init, InitializeCustomDPCObjects) 
#endif

/* put all this procedures in the paged memory-pool, all called at passiv Level */
#ifdef ALLOC_PRAGMA
#pragma	alloc_text (page, PCICC32Open)
#pragma alloc_text (page, PCICC32Close)
#pragma alloc_text (page, PCICC32Unload)
#pragma alloc_text (page, PCICC32FreeResources)
#endif

#endif // __PCICC32_DRV_H__

